/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.planning.algorithms;

import com.google.common.base.Preconditions;
import cz.insophy.inplan.plan.Bubble;
import cz.insophy.inplan.plan.WorkplaceActivity;
import cz.insophy.inplan.planning.algorithms.Direction;
import java.util.Iterator;

public abstract class FilteringWpIterator
implements Iterator<WorkplaceActivity> {
    private final Iterator<WorkplaceActivity> waIt;
    private final long cutTime;
    private final Direction dir;

    public FilteringWpIterator(Iterator<WorkplaceActivity> waIt, long cutTime, Direction dir) {
        Preconditions.checkNotNull(waIt);
        this.waIt = waIt;
        this.cutTime = cutTime;
        this.dir = dir;
    }

    @Override
    public boolean hasNext() {
        return this.waIt.hasNext();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public WorkplaceActivity next() {
        WorkplaceActivity nextWa;
        Preconditions.checkState(this.hasNext());
        WorkplaceActivity wa = this.waIt.next();
        if (wa instanceof Bubble || !this.filterWa(wa)) {
            nextWa = wa;
        } else {
            long bubEnd;
            long bubStart;
            if (this.dir == Direction.FORWARD) {
                bubStart = Math.max(this.cutTime, wa.getStart());
                bubEnd = wa.getEnd();
            } else {
                bubStart = wa.getStart();
                bubEnd = Math.min(this.cutTime, wa.getEnd());
            }
            nextWa = new Bubble(bubStart, bubEnd, wa.getWorkplace());
            this.filteringWa(wa);
        }
        return nextWa;
    }

    protected void filteringWa(WorkplaceActivity wa) {
    }

    protected abstract boolean filterWa(WorkplaceActivity var1);
}

